/* - StepperCurrentChangeListener -
 * Display the current data from the current change event
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.CurrentChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;

public class StepperCurrentChangeListener implements CurrentChangeListener{
    
    private JComboBox motorCmb;
    private JTextField currentLimitTxt;
    
    /** Creates a new instance of StepperCurrentChangeListener */
    public StepperCurrentChangeListener(JComboBox motorCmb, JTextField currentLimitTxt)
    {
        this.motorCmb = motorCmb;
        this.currentLimitTxt = currentLimitTxt;
    }

    public void currentChanged(CurrentChangeEvent currentChangeEvent)
    {
        if(currentChangeEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            currentLimitTxt.setText(Double.toString(currentChangeEvent.getValue()));
        }
    }
    
}
